% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar-register}
\alias{calendar-register}
\alias{calendars}
\alias{remove.calendars}
\alias{has.calendars}
\title{Calendars register}
\usage{
calendars()

remove.calendars(cals)

has.calendars(cals)
}
\arguments{
\item{cals}{character vector of calendars names}
}
\description{
Every calendar created with \code{create.calendar} is stored in the calendar register.
The idea behind this register is allowing calendars to be accessed by its names.
}
\details{
\code{calendars} returns the object which represents the calendars register.
Since the register inherits from \code{environment}, the calendars are 
retrieved with the \code{[[} operator.
But the register object has its own \code{print} generic which helps listing 
all registered calendars.

\code{remove.calendars} remove calendars from the register.
}
\examples{
# ACTUAL calendar
cal <- create.calendar("Actual")
cal <- calendars()[["Actual"]]
remove.calendars("Actual")
# lists registered calendars
calendars()
has.calendars(c("actual", "weekends"))
}
