% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.bm_matrix.R
\name{as.matrix.bm_matrix}
\alias{as.matrix.bm_matrix}
\alias{as.matrix.bm_bitmap}
\alias{as.matrix.bm_pixmap}
\title{Cast bitmap/pixmap objects to a (normal) matrix}
\usage{
\method{as.matrix}{bm_matrix}(x, first_row_is_top = FALSE, ...)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object.}

\item{first_row_is_top}{If \code{TRUE} the first row of the matrix will represent the top of the bitmap
(like \code{\link[grDevices:as.raster]{grDevices::as.raster()}} objects).
If \code{FALSE} the first row of the matrix will represent the bottom of the bitmap
(like \code{\link[=bm_bitmap]{bm_bitmap()}} and \code{\link[=bm_pixmap]{bm_pixmap()}} objects).}

\item{...}{Currently ignored.}
}
\value{
Either an integer matrix if \code{x} is a \code{\link[=bm_bitmap]{bm_bitmap()}} object
or a character matrix if \code{x} is a \code{\link[=bm_pixmap]{bm_pixmap()}} object.
}
\description{
\code{as.matrix.bm_matrix()} casts \code{\link[=bm_bitmap]{bm_bitmap()}} objects to a (normal) integer matrix
and \code{\link[=bm_pixmap]{bm_pixmap()}} objects to a (normal) character matrix (of color strings).
Note unless \code{first_row_is_top = TRUE} the bottom left pixel will still be
represented by the pixel in the first row and first column
(i.e. these methods simply remove the class names).
}
\examples{
 space_matrix <- matrix(0L, ncol = 8L, nrow = 8L)
 space_glyph <- bm_bitmap(space_matrix)
 print(space_glyph, px = ".")
 print(as.matrix(space_glyph))
}
