% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot_trend}
\alias{plot_trend}
\title{Plot Posterior Trend Estimates}
\usage{
plot_trend(
  x,
  CI_group = 1,
  n_points = 1000,
  quantiles = c(0.99, 0.9, 0.5, 0.25),
  quantile.col = gray(seq(1, 0, length.out = length(quantiles) + 2)[2:(length(quantiles)
    + 1)]),
  quantile.border = NA,
  median.col = "deeppink",
  median.lwd = 1,
  median.lty = 1,
  epoch.col = "black",
  epoch.lwd = 1,
  epoch.lty = 1,
  times.col = "black",
  times.lwd = 1,
  times.lty = 2,
  log = FALSE,
  xlab = "Time",
  ylab = paste(c("log", "Relative Density")[c(log, TRUE)], collapse = " "),
  main = x$CI_groups[CI_group],
  ...
)
}
\arguments{
\item{x}{A \code{birp} object containing MCMC trace and model outputs.}

\item{CI_group}{Integer; Index of the control-intervention group to plot. Default is 1.}

\item{n_points}{Integer; Number of points to evaluate the trend over time. Default is 1000.}

\item{quantiles}{Numeric vector; Quantiles to plot as shaded intervals. Must be in (0, 1). Default is c(0.99, 0.9, 0.5, 0.25).}

\item{quantile.col}{Character vector or color values; Fill colors for quantile polygons. Default is shades of gray.}

\item{quantile.border}{Character or NA; Border color for quantile polygons. Use NA to omit borders. Default is NA.}

\item{median.col}{Character; Color of the median trend line. Default is "deeppink".}

\item{median.lwd}{Numeric; Line width for the median trend. Default is 1.}

\item{median.lty}{Numeric or character; Line type for the median trend line. Default is 1 (solid).}

\item{epoch.col}{Character or color specification; Color for lines representing epoch boundaries. Default is \code{"black"}.}

\item{epoch.lwd}{Numeric; Line width for epoch boundary lines. Default is 1.}

\item{epoch.lty}{Numeric or character; Line type for epoch boundary lines. Default is 1 (solid).}

\item{times.col}{Character or color specification; Color for vertical lines representing measurement times. Default is \code{"black"}.}

\item{times.lwd}{Numeric; Line width for measurement time lines. Default is 1.}

\item{times.lty}{Numeric or character scalar; Line type for measurement time lines. Default is 2 (dashed).}

\item{log}{Logical; If \code{TRUE}, plot relative densities on a logarithmic scale; otherwise plot on the original scale. Default is \code{FALSE}.}

\item{xlab}{Character; Label for the x-axis. Default is \code{"Time"}.}

\item{ylab}{Character; Label for the y-axis. Default dynamically set to either \code{"log Relative Density"} or \code{"Relative Density"}.}

\item{main}{Character; Main title of the plot. Defaults to the name of the selected CI group.}

\item{...}{Additional graphical parameters passed to the base \code{plot} function.}
}
\value{
No return value, called for side effects.
}
\description{
Visualizes posterior trends from a \code{birp} object by plotting the median and quantile intervals of the estimated relative densities over time. Optionally, vertical lines can be added to mark epoch boundaries and survey timepoints.
}
\examples{
data <- simulate_birp()
est <- birp(data)
plot_trend(est)
}
\seealso{
\code{\link{birp}}
}
