% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot_mcmc}
\alias{plot_mcmc}
\title{Plot MCMC Traces and Posterior Densities}
\usage{
plot_mcmc(x, col = c("black", "blue"))
}
\arguments{
\item{x}{A \code{birp} object containing posterior samples.}

\item{col}{Character vector; Colors for trace and density plots. Default is c("black", "blue").}
}
\value{
No return value; the function is called for its side effects (plotting).
}
\description{
Visualizes the MCMC trace plots and posterior densities of the gamma parameters from a \code{birp} object.
}
\examples{
data <- simulate_birp()
est <- birp(data)
plot_mcmc(est)
}
\seealso{
\code{\link{birp}}
}
