% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot_epoch_pair}
\alias{plot_epoch_pair}
\title{Plotting posterior estimates of gamma pairs}
\usage{
plot_epoch_pair(
  x,
  gamma1 = 1,
  gamma2 = 2,
  xlab = .getLabelGamma.birp(x, gamma1),
  ylab = .getLabelGamma.birp(x, gamma2),
  xlim = range(x$trace_gamma[, c(gamma1, gamma2)]),
  ylim = xlim,
  col = "deeppink",
  diag.col = "black",
  diag.lwd = 1,
  diag.lty = 1,
  zero.col = "black",
  zero.lwd = 1,
  zero.lty = 2,
  print.p = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{A birp object}

\item{gamma1}{The index of the first gamma to plot}

\item{gamma2}{The index of the second gamma to plot}

\item{xlab}{A label for the x axis}

\item{ylab}{A label for the y axis}

\item{xlim}{The x-limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a "reversed axis". The default value, NULL, indicates that the range of the finite values to be plotted should be used}

\item{ylim}{The y-limits of the plot}

\item{col}{The color for the contour lines}

\item{diag.col}{The color of the diagonal line. Use NA to indicate that no line should be plotted}

\item{diag.lwd}{The line width of the diagonal line}

\item{diag.lty}{The line type of the diagonal line}

\item{zero.col}{The color of the line at zero. Use NA to indicate that no line should be plotted}

\item{zero.lwd}{The line width of the line at zero}

\item{zero.lty}{The line type of the line at zero}

\item{print.p}{If \code{TRUE}, add text representing the posterior probability of a trend change}

\item{add}{Boolean indicating if a lines should be added to an existing plot}

\item{...}{additional parameters passed to the function}
}
\value{
No return value, called for side effects.
}
\description{
Plotting posterior estimates of gamma pairs
}
\examples{
data <- simulate_birp(timesOfChange = 2)
est <- birp(data, timesOfChange = 2)
plot_epoch_pair(est)
}
\seealso{
\code{\link{birp}}
}
