% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{newsamples}
\alias{newsamples}
\title{Format aesthetics for the supplementary (new) biplot samples}
\usage{
newsamples (bp,  col = "darkorange1", pch = 1, cex = 1, label = FALSE,
label.name = NULL, label.col = NULL,label.cex = 0.75, label.side = "bottom", 
label.offset = 0.5, connected = FALSE, connect.col = "black", connect.lty=1, 
connect.lwd=1)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{col}{the colour(s) for the new samples, with default \code{darkorange1}.}

\item{pch}{the plotting character(s) for the new samples, with default \code{1}.}

\item{cex}{the character expansion(s) for the new samples, with default \code{1}.}

\item{label}{a logical value indicating whether new samples should be labelled or not, with default \code{FALSE}.}

\item{label.name}{the label names for the new samples.}

\item{label.col}{a vector of the same length as the number of new samples containing the colour(s) for the labels of the new samples, with default the colour of the sample points.}

\item{label.cex}{the label text expansion(s) for the new samples, with default \code{0.75}.}

\item{label.side}{the side at which the label of the plotted point appears, with default \code{bottom}. Note that unlike the argument \code{pos} in \code{text()}, options are "\code{bottom}", "\code{left}", "\code{top}","\code{right}" and not \code{1}, \code{2}, \code{3}, \code{4}.}

\item{label.offset}{the offset of the label from the plotted point. See \code{?text} for a detailed explanation of the argument \code{offset}.}

\item{connected}{a logical value indicating whether samples are connected in order of rows of the data matrix, with default \code{FALSE}.}

\item{connect.col}{the colour of the connecting line, with default \code{black}.}

\item{connect.lty}{the line type of the connecting line, with default \code{1}.}

\item{connect.lwd}{the line width of the connecting line, with default \code{1}.}
}
\value{
The object of class \code{biplot} will be appended with a list called \code{newsamples} containing the following elements:
\item{col}{the colour(s) of the new samples.}
\item{pch}{the plotting character(s) of the new samples.}
\item{cex}{the character expansion(s) of the plotting character(s) of the new samples.}
\item{label}{a logical value indicating whether new samples are labelled.}
\item{label.col}{the label colours of the new samples.}
\item{label.cex}{the label text expansions of the new samples.}
\item{label.side}{the side at which the label of the plotted point appears.}
\item{label.offset}{the offset of the label from the plotted point.}
\item{connected}{a logical value indicating whether new samples are connected.}
\item{connect.col}{the colour of the connecting line.}
\item{connect.lty}{the line type of the connecting line.}
\item{connect.lwd}{the line width of the connecting line.}
}
\description{
This function allows formatting changes to new samples.
}
\examples{
biplot(data = iris[1:145,]) |> PCA() |> samples(col = "grey") |>
interpolate(newdata = iris[146:150,]) |> newsamples(col = rainbow(6), pch=15) |> plot()

}
\seealso{
\link{biplot}, \link{samples}
}
