% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multi_dynamic.R
\name{fit_multiple_growth}
\alias{fit_multiple_growth}
\title{Fitting growth models to multiple dynamic experiments}
\usage{
fit_multiple_growth(
  starting_point,
  experiment_data,
  known_pars,
  sec_model_names,
  ...,
  check = TRUE,
  formula = logN ~ time
)
}
\arguments{
\item{starting_point}{a named vector of starting values for the model parameters.}

\item{experiment_data}{a nested list with the experimental data. Each entry describes
one experiment as a list with two elements: data and conditions. \code{data} is a tibble
with a column giving the elapsed time (named "time" by default) and another one
with the decimal logarithm of the population size (named "logN" by default).
\code{conditions} is a tibble with one column giving the elapsed time (using the
same name as \code{data}) and as many additional columns as environmental factors.
The default column names can be changed with the formula argument.}

\item{known_pars}{named vector of known model parameters}

\item{sec_model_names}{named character vector with names the
environmental conditions and values the secondary model (see secondary_model_data).}

\item{...}{additional arguments for \code{\link{modFit}}.}

\item{check}{Whether to check the validity of the models. \code{TRUE} by default.}

\item{formula}{an object of class "formula" describing the x and y variables.
\code{logN ~ time} as a default.}
}
\value{
An instance of \code{\link{FitMultipleDynamicGrowth}}.
}
\description{
This functions enables to fit a growth model using a dataset comprised of
several experiments with potentially different dynamic experimental conditions.
Note that the definition of secondary models must comply with the
`secondary_model_data` function.
}
\examples{
\donttest{
## We will use the multiple_experiments data set

data("multiple_experiments")

## For each environmental factor, we need to defined a model

sec_names <- c(temperature = "CPM", pH = "CPM")

## Any model parameter can be fixed

known <- list(Nmax = 1e8, N0 = 1e0, Q0 = 1e-3,
    temperature_n = 2, temperature_xmin = 20, temperature_xmax = 35,
    pH_n = 2, pH_xmin = 5.5, pH_xmax = 7.5, pH_xopt = 6.5)

## The rest require starting values for model fitting

start <- list(mu_opt = .8, temperature_xopt = 30)

## We can now call the fitting function

global_fit <- fit_multiple_growth(start, multiple_experiments, known, sec_names)

## Parameter estimates can be retrieved with summary

summary(global_fit)

## We can compare fitted model against observations

plot(global_fit)

## Any single environmental factor can be added to the plot using add_factor

plot(global_fit, add_factor = "temperature")
}

}
