% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-docs.R
\name{export_word}
\alias{export_word}
\title{Export BioCompute Object as Word document}
\usage{
export_word(x, file, wrap = FALSE, linewidth = 80, ...)
}
\arguments{
\item{x}{BioCompute Object JSON string from \code{\link{convert_json}}}

\item{file}{Word (docx) output file path}

\item{wrap}{Should the long lines be wrapped?}

\item{linewidth}{Maximum linewidth when \code{wrap} is \code{TRUE}.}

\item{...}{Additional parameters for \code{\link[rmarkdown]{render}}.}
}
\value{
Path to the output file
}
\description{
Export BioCompute Object as Word document
}
\examples{
\dontrun{
file_docx <- tempfile(fileext = ".docx")
generate_example("HCV1a") \%>\%
  convert_json() \%>\%
  export_word(file_docx)
}
}
