% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_convert.R
\name{scan_to_spatial}
\alias{scan_to_spatial}
\title{convert a polar scan into a spatial object.}
\usage{
scan_to_spatial(scan, lat, lon, k = 4/3, re = 6378, rp = 6357)
}
\arguments{
\item{scan}{a scan (sweep) of class scan}

\item{lat}{Geodetic latitude of the radar in degrees. If missing taken from \code{scan}.}

\item{lon}{Geodetic longitude of the radar in degrees. If missing taken from \code{scan}.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
a SpatialPointsDataFrame
}
\description{
Georeferences the center of  pixels for a scan into a SpatialPointsDataFrame object.
}
\details{
Beam altitude accounts for the curvature of the earth, using \link{beam_height}.
Distance from the radar over the earth's surface is calculated using \link{beam_distance}.
}
\examples{
# load example scan:
data(example_scan)

# convert to a SpatialPointsDataFrame:
scan_to_spatial(example_scan)
}
