% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_vvp.R
\name{sd_vvp_threshold<-}
\alias{sd_vvp_threshold<-}
\alias{sd_vvp_threshold<-.vp}
\alias{sd_vvp_threshold<-.list}
\alias{sd_vvp_threshold<-.vpts}
\title{Set threshold of the VVP-retrieved radial velocity standard deviation}
\usage{
sd_vvp_threshold(x) <- value

\method{sd_vvp_threshold}{vp}(x) <- value

\method{sd_vvp_threshold}{list}(x) <- value

\method{sd_vvp_threshold}{vpts}(x) <- value
}
\arguments{
\item{x}{a \code{vp}, list of \code{vp} or \code{vpts} object}

\item{value}{the value to assign}
}
\description{
Sets the threshold for \code{sd_vvp}. Altitude layers with \code{sd_vvp}
below this threshold are assumed to have an aerial density of zero
individuals. This method updates the migration densities
in \code{x$data$dens}
}
\details{
See also \link{sd_vvp_threshold} for retrieving an objects radial
velocity standard deviation.
}
\examples{
# load example data:
data(example_vp)
data(example_vpts)

# change or set the threshold for a single vertical profile:
sd_vvp_threshold(example_vp) <- 2

# change or set the threshold for a vertical profile time series:
sd_vvp_threshold(example_vp) <- 2

# retrieve threshold for a single vertical profile:
sd_vvp_threshold(example_vp)

# retrieve threshold for a vertical profile time series:
sd_vvp_threshold(example_vpts)
}
