% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_optimize_para.R
\name{optimize_para}
\alias{optimize_para}
\title{Process: Optimizing Parameters}
\usage{
optimize_para(
  data,
  id,
  obj_func,
  n_params,
  n_trials,
  lower,
  upper,
  initial_params = NA,
  initial_size = 50,
  iteration = 10,
  seed = 123,
  algorithm
)
}
\arguments{
\item{data}{[data.frame] raw data. 
This data should include the following mandatory columns: 
 \itemize{
   \item "sub"
   \item "time_line" (e.g., "Block", "Trial")
   \item "L_choice"
   \item "R_choice"
   \item "L_reward"
   \item "R_reward"
   \item "sub_choose"
 }}

\item{id}{[integer] which subject is going to be analyzed.
is being analyzed. The value should correspond to an entry in the "sub" 
column, which must contain the subject IDs. 
e.g., `id = 18`}

\item{obj_func}{[function] A function with only ONE argument `params`.
Refer to `binaryRL::TD` to mimic the establishment of an objective function.}

\item{n_params}{[integer] The number of free parameters in your model.}

\item{n_trials}{[integer] The total number of trials in your experiment.}

\item{lower}{[vector] lower bounds of free parameters}

\item{upper}{[vector] upper bounds of free parameters}

\item{initial_params}{[vector] Initial values for the free parameters. 
automatically generate initial values.
for `L-BFGS-B`, `GenSA`, set `initial = c(0, 0, ...)`}

\item{initial_size}{[integer] Initial population size for the free parameters. 
automatically generate initial values.
for `Bayesian`, `GA`, set `initial = 50`}

\item{iteration}{[integer] the number of iteration}

\item{seed}{[integer] random seed. This ensures that the results are 
reproducible and remain the same each time the function is run. 
default: `seed = 123`}

\item{algorithm}{[character] Choose an algorithm package from
`L-BFGS-B`, `GenSA`, `GA`, `DEoptim`, `PSO`, `Bayesian`, `CMA-ES`.
In addition, any algorithm from the `nloptr` package is also
supported. If your chosen `nloptr` algorithm requires a local search,
you need to input a character vector. The first element represents
the algorithm used for global search, and the second element represents
the algorithm used for local search.}
}
\value{
the result of binaryRL with optimal parameters
}
\description{
This function is an internal function of `fit_p`. 
 We isolate it from direct use by capable users.

 The function provides several optimization algorithms:
  \itemize{
    \item 1. L-BFGS-B (from `stats::optim`);
    \item 2. Simulated Annealing (`GenSA`);
    \item 3. Genetic Algorithm (`GA`);
    \item 4. Differential Evolution (`DEoptim`);
    \item 5. Particle Swarm Optimization (`pso`);
    \item 6. Bayesian Optimization (`mlrMBO`);
    \item 7. Covariance Matrix Adapting Evolutionary Strategy (`cmaes`);
    \item 8. Nonlinear Optimization (`nloptr`)
  }

 For more information, please refer to the GitHub repository:
 https://github.com/yuki-961004/binaryRL
}
