% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.MMLong.R
\name{anova.MMLong}
\alias{anova.MMLong}
\title{Comparing Two Models: ANOVA}
\usage{
\method{anova}{MMLong}(object, ...)
}
\arguments{
\item{object}{a list with two elements. Element 1 is the first model fit using \code{mm}, element 2 is the second model fit using \code{mm}}

\item{...}{additional control variables}
}
\value{
ANOVA table
}
\description{
Compute analysis of variance tables for two fitted model objects
}
\examples{
\donttest{
data(datrand)
fit1 <- mm(Y~time*binary, t.formula=~1, data=datrand, id=id, step.max=4, verbose=FALSE)
fit2 <- mm(Y~time*binary, t.formula=~1, lv.formula =~1, data=datrand,
id=id, step.max=4, verbose=FALSE)
anova(fit1,fit2)}
}
