% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTC1.R
\name{expectOrderBeta}
\alias{expectOrderBeta}
\title{Determine a vector of probabilities for informative group
testing algorithms}
\usage{
expectOrderBeta(p, alpha, grp.sz, ...)
}
\arguments{
\item{p}{overall probability of disease that will be used to determine a 
vector of individual risk probabilities. This is the expected value of a 
random variable with a beta distribution, 
\eqn{\frac{\alpha}{\alpha + \beta}}{\alpha/(\alpha + \beta)}.}

\item{alpha}{a shape parameter for the beta distribution that
specifies the degree of heterogeneity for the determined
probability vector.}

\item{grp.sz}{the number of total individuals for which to
determine risk probabilities.}

\item{...}{arguments to be passed to the \code{beta.dist} function 
written by Michael Black for Black et al. (2015).}
}
\value{
A vector of individual risk probabilities.
}
\description{
Find the expected value of order statistics from a beta 
distribution. This function is used to provide a set of individual 
risk probabilities for informative group testing.
}
\details{
This function uses the \code{beta.dist} function from 
Black et al. (2015) to determine a vector of individual risk probabilities,
ordered from least to greatest. Depending on the specified probability, 
\eqn{\alpha} level, and overall group size, simulation may be necessary in 
order to determine the probabilities. For this reason, the user should set 
a seed in order to reproduce results. The number of simulations can be
specified by the user, with 10,000 as the default. The \kbd{expectOrderBeta} 
function augments the \code{beta.dist} function by checking whether
simulation is needed before attempting to determine the probabilities. 
The \kbd{expectOrderBeta} function allows for the number of simulations to 
be passed on to the \code{beta.dist} function as an additional argument.
See Black et al. (2015) for additional details on the original \kbd{beta.dist} 
function.
}
\examples{
set.seed(8791)
expectOrderBeta(p=0.03, alpha=0.5, grp.sz=100)

set.seed(52613)
expectOrderBeta(p=0.005, alpha=2, grp.sz=40, num.sim=5000)
}
\references{
\insertRef{Black2015}{binGroup2}
}
\seealso{
\code{\link{expectOrderBeta}} for generating a vector of individual 
risk probabilities and \code{\link{informativeArrayProb}} for arranging a 
vector of individual risk probabilities in a matrix for informative array 
testing without master pooling.
}
\author{
Brianna D. Hitt
}
