% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{CE_MLBM}
\alias{CE_MLBM}
\title{CE_MLBM function for agreement between coclustering partitions in the MBLM}
\usage{
CE_MLBM(z,v,w,zprime,vprime,wprime)
}
\arguments{
\item{z}{numeric vector  specifying the class of  rows.}

\item{v}{numeric vector specifying the class of column partitions for the first matrix.}

\item{w}{numeric vector specifying the class of column partitions for the second matrix.}

\item{zprime}{numeric vector  specifying another partitions of rows.}

\item{vprime}{numeric vector specifying another partition of columns for the first matrix.}

\item{wprime}{numeric vector specifying another partition of columns for the second matrix.}
}
\value{
a the value of the index
}
\description{
Produce a measure of agreement between two triplets of partitions for coclustering. A value of 1 means a perfect match.
}
\examples{
\donttest{require(bikm1)
require(bikm1)
set.seed(42)
n=200
J=120
K=120
g=2
h=2
l=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$alpha_gh=matrix(runif(4),ncol=h)
theta$beta_gl=matrix(runif(4),ncol=l)
data=BinBlocRnd_MLBM(n,J,K,theta)
res=BIKM1_MLBM_Binary(data$x,data$y,2,2,2,4,init_choice='smallVBayes')
error=CE_MLBM(res@model_max$z,res@model_max$v,res@model_max$w,data$xrow,data$xcolx,data$xcoly)
}
}
