% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-test-data.R
\name{bike_write_test_data}
\alias{bike_write_test_data}
\title{Writes test data bundled with package to zip files}
\usage{
bike_write_test_data(data_dir = tempdir())
}
\arguments{
\item{data_dir}{Directory in which data are to be extracted. Defaults to
\code{tempdir()}. If any other directory is specified, files ought to be
removed with \code{bike_rm_test_data()}.}
}
\description{
Writes very small test files to disk that can be used to test the package.
The entire package works by reading zip-compressed data files provided by the
various hire bicycle systems. This function generates some equivalent data
that can be read into an \code{SQLite} database by the
\code{store_bikedata()} function, so that all other package functionality can
then be tested from the resultant database. This function is also used in the
examples of all other functions.
}
\examples{
bike_write_test_data ()
list.files (tempdir ())
bike_rm_test_data ()

bike_write_test_data (data_dir = '.')
list.files ()
bike_rm_test_data (data_dir = '.')
}
