% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_conditions.r
\name{radiometric.surface.temp}
\alias{radiometric.surface.temp}
\title{Radiometric Surface Temperature}
\usage{
radiometric.surface.temp(longwave_up, emissivity,
  constants = bigleaf.constants())
}
\arguments{
\item{longwave_up}{Longwave upward radiation (W m-2)}

\item{emissivity}{Infrared emissivity of the surface (-)}

\item{constants}{sigma - Stefan-Boltzmann constant (W m-2 K-4) \cr
Kelvin - conversion degree Celsius to Kelvin}
}
\value{
a data.frame with the following columns:
        \item{Trad_K}{Radiometric surface temperature (K)} \cr
        \item{Trad_degC}{Radiometric surface temperature (degC)}
}
\description{
Radiometric surface temperature from longwave upward radiation
             measurements.
}
\details{
Radiometric surface temperature (Trad) is calculated as:

           \deqn{Trad = LW_up / (\sigma \epsilon)^(1/4)}
}
\examples{
# determine radiative temperature of an object that has an emissivity of 0.98 
# and emits longwave radiation of 400Wm-2  
radiometric.surface.temp(400,0.98)

}
