% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uci_parse.R
\name{uci_parse}
\alias{uci_parse}
\title{Parse GUI commands from chess engine}
\usage{
uci_parse(ucilog, filter = "bestmove")
}
\arguments{
\item{ucilog}{strings from uci_quit() or uci_read()$temp}

\item{filter}{string, one of 'bestmove' (default), 'score' or 'bestline'}
}
\value{
strings with parsed information from engine
}
\description{
Parse GUI commands from chess engine.
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
require(processx)
e <- uci_engine(engine_path)
e <- uci_go(depth = 10)
rslt <- uci_quit(e)
uci_parse(rslt)
# Using pipe '\%>\%' from magrittr:
require(magrittr)
uci_engine(engine_path) \%>\% uci_go(depth = 10) \%>\% uci_quit() \%>\% uci_parse()}
}
