% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.labels}
\alias{bdm.labels}
\title{Get data-point clustering labels.}
\usage{
bdm.labels(bdm, layer = 1, merged = T)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{layer}{The number of the t-SNE layer (1 by default).}

\item{merged}{A logical value. If TRUE (default value) and the \var{bdm} has been merged, the returned data-point labelling correspond to merged clusters. If \var{merged} is set to FALSE or the \var{bdm} has not been merged the data-point labels that are returned correspond to the top-level clustering.}
}
\value{
A vector of data-point clustering labels.
}
\description{
Given that clusters are computed at grid-cell level, this function returns the clustering label for each data-point.
}
\examples{

bdm.example()
exMap.labels <- bdm.labels(exMap)
}
