% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDocumentation.R
\docType{data}
\name{LDA_Data}
\alias{LDA_Data}
\title{A list consisting of Training and Test data along with corresponding class labels.}
\format{A list consisting of:
\describe{
  \item{TrainData}{ (10000 x 10) Matrix of independent normally-distributed training samples conditioned on class membership.
  There are 7000 samples belonging to class 1, and 3000 samples belonging to class 2.
  The class 1 mean vector is the vector of length 10 consisting only of -2. Likewise,
  the class 2 mean vector is the vector of length 10 consisting only of 2.
  The shared covariance matrix has (i,j) entry (0.5)^|i-j|.}
  \item{TestData}{ (1000 x 10) Matrix of independenttest data features with the same distributions and class proportions as \code{TrainData}}.
  \item{Train}{ (10000 x 1) Vector of class labels for the samples in \code{TrainData}.}
  \item{TestCat}{ (1000 x 1) Vector of class labels for the samples in \code{TestData}.}
  ...
}}
\usage{
LDA_Data
}
\description{
A list consisting of Training and Test data along with corresponding class labels.
}
\references{
Lapanowski, Alexander F., and Gaynanova, Irina. ``Compressing large-sample data for discriminant analysis'', preprint.
}
\keyword{datasets}
