% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFunctions.R
\name{saveScenarios}
\alias{saveScenarios}
\title{saveScenarios}
\usage{
saveScenarios(scenario_list, save_path = tempdir())
}
\arguments{
\item{scenario_list}{An object of class \code{scenario_list}, e.g. created with \code{simulateScenarios()}}

\item{save_path}{A string providing the path for the directory in which the directory of the
scenario should be created, Default: \code{\link[base]{tempfile}}}
}
\value{
A named list of length 2 with the scenario numbers and the \code{save_path}
}
\description{
Saves the scenario data in a newly created or existing directory
}
\examples{
  scenarios_list <- simulateScenarios(
    n_subjects_list     = list(c(10, 20, 30)),
    response_rates_list = list(rep(0.9, 3)),
    n_trials            = 10)

  save_info      <- saveScenarios(scenarios_list)
  scenarios_list <- loadScenarios(scenario_numbers = save_info$scenario_numbers,
                                  load_path        = save_info$path)
}
\seealso{
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{loadScenarios}}
\code{\link[base]{tempfile}}
}
\author{
Stephan Wojciekowski
}
