% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisFunctions.R
\name{saveAnalyses}
\alias{saveAnalyses}
\title{saveAnalyses}
\usage{
saveAnalyses(analyses_list, save_path = tempdir(), analysis_numbers = NULL)
}
\arguments{
\item{analyses_list}{An object of class \code{analysis_list},
as created with \code{\link[bhmbasket]{performAnalyses}}}

\item{save_path}{A string for the path where the scenarios are being stored,
Default: \code{\link[base]{tempfile}}}

\item{analysis_numbers}{A positive integer naming the analysis number.
If \code{NULL}, the function will look for the number of saved analyses of the scenario
in the directory and add 1, Default: \code{NULL}}
}
\value{
A named list of length 3 of vectors with scenario and analysis numbers and
the \code{save_path}
}
\description{
This function saves an object of class \code{analysis_list}
}
\examples{
  trial_data <- createTrial(
    n_subjects   = c(10, 20, 30),
    n_responders = c(1, 2, 3))

  analysis_list <- performAnalyses(
    scenario_list      = trial_data,
    target_rates       = rep(0.5, 3),
    n_mcmc_iterations  = 100,
    n_cores            = 1L)

  save_info     <- saveAnalyses(analysis_list)
  analysis_list <- loadAnalyses(scenario_numbers = save_info$scenario_numbers,
                                analysis_numbers = save_info$analysis_numbers,
                                load_path        = save_info$path)
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{loadAnalyses}}
\code{\link[base]{tempfile}}
}
\author{
Stephan Wojciekowski
}
