% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Wenchuan}
\alias{Wenchuan}
\title{Post-traumatic stress disorder symptoms of Wenchuan earthquake survivors}
\format{
A matrix with 362 rows and 17 columns:
\describe{
  \item{intrusion}{Repeated, disturbing memories, thoughts, or images of a 
  stressful experience from the past?}
  \item{dreams}{Repeated, disturbing dreams of a stressful experience from 
  the past?}
  \item{flash}{Suddenly acting or feeling as if a stressful experience were 
  happening again (as if you were reliving it)?}
  \item{upset}{Feeling very upset when something reminded you of a stressful 
  experience from the past?}
  \item{physior}{Having physical reactions (e.g., heart pounding, trouble 
  breathing, sweating) when something reminded you of a stressful experience 
  from the past?}
  \item{avoidth}{Avoiding thinking about or talking about a stressful 
  experience from the past or avoiding having feelings related to it?}
  \item{avoidact}{Avoiding activities or situations because they reminded you 
  of a stressful experience from the past?}
  \item{amnesia}{Trouble remembering important parts of a stressful 
  experience from the past?}
  \item{lossint}{Loss of interest in activities that you used to enjoy?}
  \item{distant}{Feeling distant or cut off from other people?}
  \item{numb}{Feeling emotionally numb or being unable to have loving 
  feelings for those close to you?}
  \item{future}{Feeling as if your future will somehow be cut short?}
  \item{sleep}{Trouble falling or staying asleep?}
  \item{anger}{Feeling irritable or having angry outbursts?}
  \item{concen}{Having difficulty concentrating?}
  \item{hyper}{Being "super-alert" or watchful or on guard?}
  \item{startle}{Feeling jumpy or easily startled?}
}
}
\source{
\url{http://psychosystems.org/wp-content/uploads/2014/10/Wenchuan.csv}
}
\usage{
data("Wenchuan")
}
\description{
A data set containing items measuring symptoms of posttraumatic stress 
disorder (PTSD) \insertCite{McNallyEtAl_2015}{bgms}. Participants were 362 
Chinese adults who survived the Wenchuan earthquake and lost at least one 
child in the disaster. PTSD symptoms were reported using the civilian version 
of the Posttraumatic Checklist, which consists of 17 items, each assessing 
one of the DSM-IV symptoms of PTSD. Participants rated each item on a 
five-point scale ranging from ``not at all'' to ``extremely'' to indicate how 
much the symptom bothered them in the past month.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
