% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_parse.R
\name{ParsePlot}
\alias{ParsePlot}
\title{Parse Plot}
\usage{
ParsePlot(
  plot.data,
  project.dir = "Results/",
  project.name = FileName(name = "Print"),
  graphic.type = "pdf",
  plot.size = "15,10",
  scaling = 100,
  plot.aspect = NULL,
  save.data = FALSE,
  vector.graphic = FALSE,
  point.size = 12,
  font.type = "serif",
  one.file = TRUE,
  ppi = 300,
  units = "in",
  layout = "a4",
  layout.inverse = FALSE,
  return.files = FALSE,
  ...
)
}
\arguments{
\item{plot.data}{a list of plots}

\item{project.dir}{define where to save data, Default: 'Results/'}

\item{project.name}{define name of project, Default: 'FileName(name="Print")'}

\item{graphic.type}{type of graphics to use (e.g., pdf, png, ps), Default: 'pdf'}

\item{plot.size}{size of plot, Default: '15,10'}

\item{scaling}{scale size of plot, Default: 100}

\item{plot.aspect}{aspect of plot, Default: NULL}

\item{save.data}{logical, indicating whether or not to save data, Default: FALSE}

\item{vector.graphic}{logical, indicating whether or not visualizations should be vector or raster graphics, Default: FALSE}

\item{point.size}{point size used for visualizations, Default: 12}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{one.file}{logical, indicating whether or not visualizations should be placed in one or several files, Default: TRUE}

\item{ppi}{define pixel per inch used for visualizations, Default: 300}

\item{units}{define unit of length used for visualizations, Default: 'in'}

\item{layout}{define a layout size for visualizations, Default: 'a4'}

\item{layout.inverse}{logical, indicating whether or not to inverse layout (e.g., landscape) , Default: FALSE}

\item{return.files}{logical, indicating whether or not to return saved file names}

\item{...}{further arguments passed to or from other methods}
}
\description{
Display and/or save plots
}
\examples{
# Create three plots
plot.data <- lapply(1:3, function (i) {
  # Open new device
  grDevices::dev.new()
  # Print plot
  plot(1:i)
  # Record plot
  p <- grDevices::recordPlot()
  # Turn off graphics device drive
  grDevices::dev.off()
  return (p)
} )

# Print plots
ParsePlot(plot.data)
\donttest{
# Save plots as png with a4 layout and return file names
project.dir <- tempdir()
project.name <- FileName(name="Testing-Plot")
ParsePlot(plot.data,
          project.dir = project.dir,
          project.name = project.name,
          graphic.type = "png",
          save.data = TRUE,
          layout = "a4",
          return.files = TRUE
)
# [1] "\\Temp/Project-Testing-Plot01-1528833217.png"
# [2] "\\Temp/Project-Testing-Plot02-1528833217.png"
# [3] "\\Temp/Project-Testing-Plot03-1528833217.png"
# Save plots as single PowerPoint (default) and return file names
project.dir <- tempdir()
project.name <- FileName(name="Testing-Plot")
ParsePlot(plot.data,
          project.dir = project.dir,
          project.name = project.name,
          vector.graphic = FALSE,
          graphic.type = "pptx",
          layout = "pw",
          save.data = TRUE,
          return.files = TRUE
)
# [1] "\\Temp/Project-Testing-Plot-1528833342.pptx"
}
}
\seealso{
\code{\link[grDevices]{dev}},\code{\link[grDevices]{png}},\code{\link[grDevices]{ps.options}},\code{\link[grDevices]{recordPlot}}
 \code{\link[utils]{head}}
 \code{\link[png]{readPNG}}
 \code{\link[graphics]{par}},\code{\link[graphics]{plot}},\code{\link[graphics]{rasterImage}}
 \code{\link[officer]{read_pptx}},\code{\link[officer]{add_slide}},\code{\link[officer]{ph_with}}
 \code{\link[rvg]{dml}}
}
