% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_misc.R
\name{AddNames}
\alias{AddNames}
\title{Add Names}
\usage{
AddNames(
  par,
  job.names,
  job.group = NULL,
  keep.par = TRUE,
  names.only = FALSE,
  ...
)
}
\arguments{
\item{par}{defined parameter to analyze (e.g., "cor[1,2]")}

\item{job.names}{names of all parameters in analysis, Default: NULL}

\item{job.group}{for some hierarchical models with several layers of parameter names (e.g., latent and observed parameters), Default: NULL}

\item{keep.par}{logical, indicating whether or not to keep parameter name (e.g., "cor[1,2]"), Default: TRUE}

\item{names.only}{logical, indicating whether or not to return vector (TRUE) or string with separator (e.g., "cor[1,2]: A vs. B"), Default: FALSE}

\item{...}{further arguments passed to or from other methods}
}
\description{
Add names to columns from naming list
}
\examples{
par <- "cor[1,2]"
job.names <- c("A","B")
AddNames(par, job.names, keep.par = TRUE)
# [1]  "cor[1,2]: A vs. B"
AddNames(par, job.names, keep.par = FALSE)
# [1]  "A vs. B"
AddNames(par, job.names, names.only = TRUE)
# [1]  "A" "B"
}
