% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_summary.R
\name{SumMCMC}
\alias{SumMCMC}
\title{Summarize MCMC}
\usage{
SumMCMC(par, par.names, job.names = NULL, job.group = NULL,
  credible.region = 0.95, ROPE = NULL, n.data, ...)
}
\arguments{
\item{par}{defined parameter}

\item{par.names}{parameter names}

\item{job.names}{names of all parameters in analysis, Default: NULL}

\item{job.group}{for some hierarchical models with several layers of parameter names (e.g., latent and observed parameters), Default: NULL}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}

\item{ROPE}{define range for region of practical equivalence (e.g., c(-0.05 , 0.05), Default: NULL}

\item{n.data}{sample size for each parameter}

\item{...}{further arguments passed to or from other methods}
}
\description{
The function provide a summary of each parameter of interest (mean, median, mode, effective sample size (ESS), HDI and n)
}
\seealso{
\code{\link[coda]{effectiveSize}}
}
