% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbinbf01.R
\name{nbinbf01}
\alias{nbinbf01}
\title{Sample size determination for binomial Bayes factor}
\usage{
nbinbf01(
  k,
  power,
  p0 = 0.5,
  type = c("point", "direction"),
  a = 1,
  b = 1,
  dp = NA,
  da = a,
  db = b,
  dl = 0,
  du = 1,
  lower.tail = TRUE,
  nrange = c(1, 10^4),
  ...
)
}
\arguments{
\item{k}{Bayes factor threshold}

\item{power}{Target power}

\item{p0}{Tested binomial proportion. Defaults to \code{0.5}}

\item{type}{Type of test. Can be \code{"point"} or \code{"directional"}.
Defaults to \code{"point"}}

\item{a}{Number of successes parameter of the beta analysis prior
distribution. Defaults to \code{1}}

\item{b}{Number of failures parameter of the beta analysis prior
distribution. Defaults to \code{1}}

\item{dp}{Fixed binomial proportion assumed for the power calculation. Set to
\code{NA} to use a truncated beta design prior instead (specified via the
\code{da}, \code{db}, \code{dl}, and \code{du} arguments). Defaults to
\code{NA}}

\item{da}{Number of successes parameter of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
the same value \code{a} as specified for the analysis prior}

\item{db}{Number of failures parameter of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
the same value \code{b} as specified for the analysis prior}

\item{dl}{Lower truncation limit of of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
\code{0}}

\item{du}{Upper truncation limit of of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
\code{1}}

\item{lower.tail}{Logical indicating whether Pr(\eqn{\mathrm{BF}_{01}}{BF01}
\eqn{\leq}{<=} \code{k}) (\code{TRUE}) or Pr(\eqn{\mathrm{BF}_{01}}{BF01}
\eqn{>} \code{k}) (\code{FALSE}) should be computed. Defaults to
\code{TRUE}}

\item{nrange}{Sample size search range over which numerical search is
performed. Defaults to \code{c(1, 10^4)}}

\item{...}{Other arguments passed to \code{stats::uniroot}}
}
\value{
The required sample size to achieve the specified power
}
\description{
This function computes the required sample size to obtain a
    binomial Bayes factor (\link{binbf01}) more extreme than a threshold
    \code{k} with a specified target power.
}
\examples{
## sample size parameters
pow <- 0.9
p0 <- 3/4
a <- 1
b <- 1
k <- 1/10

\dontrun{
## sample sizes for directional testing
(nH1 <- nbinbf01(k = k, power = pow, p0 = p0, type = "direction", a = a,
                 b = b, da = a, db = b, dl = p0, du = 1))
(nH0 <- nbinbf01(k = 1/k, power = pow, p0 = p0, type = "direction", a = a,
                 b = b, da = a, db = b, dl = 0, du = p0, lower.tail = FALSE))
nseq <- seq(1, 1.1*max(c(nH1, nH0)), length.out = 100)
powH1 <- pbinbf01(k = k, n = nseq, p0 = p0, type = "direction", a = a,
                  b = b, da = a, db = b, dl = p0, du = 1)
powH0 <- pbinbf01(k = 1/k, n = nseq, p0 = p0, type = "direction", a = a,
                  b = b, da = a, db = b, dl = 0, du = p0, lower.tail = FALSE)
matplot(nseq, cbind(powH1, powH0), type = "s", xlab = "n", ylab = "Power", lty = 1,
        ylim = c(0, 1), col = c(2, 4), las = 1)
abline(h = pow, lty = 2)
abline(v = c(nH1, nH0), col = c(2, 4), lty = 2)
legend("topleft", legend = c("H1", "H0"), lty = 1, col = c(2, 4))

## sample sizes for point null testing
(nH1 <- nbinbf01(k = k, power = pow, p0 = p0, type = "point", a = a,
                 b = b, da = a, db = b))
(nH0 <- nbinbf01(k = 1/k, power = pow, p0 = p0, type = "point", a = a,
                 b = b, dp = p0, lower.tail = FALSE, nrange = c(1, 10^5)))
nseq <- seq(1, max(c(nH1, nH0)), length.out = 100)
powH1 <- pbinbf01(k = k, n = nseq, p0 = p0, type = "point", a = a,
                  b = b, da = a, db = b, dl = 0, du = 1)
powH0 <- pbinbf01(k = 1/k, n = nseq, p0 = p0, type = "point", a = a,
                  b = b, dp = p0, lower.tail = FALSE)
matplot(nseq, cbind(powH1, powH0), type = "s", xlab = "n", ylab = "Power", lty = 1,
        ylim = c(0, 1), col = c(2, 4), las = 1)
abline(h = pow, lty = 2)
abline(v = c(nH1, nH0), col = c(2, 4), lty = 2)
legend("topleft", legend = c("H1", "H0"), lty = 1, col = c(2, 4))
}
}
\seealso{
\link{pbinbf01}, \link{binbf01}
}
\author{
Samuel Pawel
}
