% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{observedmoments}
\alias{observedmoments}
\title{Compute Moments of Observed Value Distribution.}
\usage{
observedmoments(
  x,
  type = c("raw", "central", "standardized"),
  orders = 4,
  correct = TRUE
)
}
\arguments{
\item{x}{A vector of values, the distribution of which moments are to be calculated.}

\item{type}{A character vector determining which moment-types are to be calculated. Permissible values are \code{"raw"}, \code{"central"}, and \code{"standardized"}.}

\item{orders}{The number of moment-orders to be calculated for each of the moment-types.}

\item{correct}{Whether to include bias correction in estimation of orders. Default is \code{TRUE}.}
}
\value{
A list of moment types, each a list of moment orders.
}
\description{
Computes Raw, Central, or Standardized moment properties of a vector of observed scores.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100))

# To compute the first four raw, central, and standardized moments for this
# distribution of observed scores using observedmoments():
observedmoments(x = testdata, type = c("raw", "central", "standardized"),
orders = 4, correct = TRUE)
}
