% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{rBeta.4P}
\alias{rBeta.4P}
\title{Random Number Generation under the Four-Parameter Beta Probability Density Distribution.}
\usage{
rBeta.4P(n, l, u, alpha, beta)
}
\arguments{
\item{n}{Number of draws.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}
}
\value{
A vector with length \code{n} of random values drawn from the four-parameter beta distribution.
}
\description{
Function for generating random numbers from a specified four-parameter beta distribution.
}
\examples{
# Assume some variable follows a four-parameter beta distribution with
# location parameters \\code{l = 0.25} and \\code{u = .75}, and shape
# parameters \\code{alpha = 5} and \\code{beta = 3}. To draw a random
# value from this distribution using \\code{rBeta.4P()}:
rBeta.4P(n = 1, l = .25, u = .75, alpha = 5, beta = 3)
}
