% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{pBeta.4P}
\alias{pBeta.4P}
\title{Cumulative Probability Function under the Four-Parameter Beta Probability Density Distribution.}
\usage{
pBeta.4P(q, l, u, alpha, beta, lt = TRUE)
}
\arguments{
\item{q}{The quantile or a vector of quantiles for which the proportion is to be calculated.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}

\item{lt}{Whether the proportion to be calculated is to be under the lower or upper tail. Default is TRUE (lower tail).}
}
\value{
A vector of proportions of observations falling under specified quantiles under the four-parameter beta distribution.
}
\description{
Function for calculating the proportion of observations up to a specifiable quantile under the four-parameter beta distribution.
}
\examples{
# Assume some variable follows a four-parameter beta distribution with
# location parameters \\code{l = 0.25} and \\code{u = .75}, and shape
# parameters \\code{alpha = 5} and \\code{beta = 3}. To compute the
# cumulative probability at a specific point of the distribution (e.g., .5)
# using \\code{pBeta.4P()}:
pBeta.4P(q = .5, l = .25, u = .75, alpha = 5, beta = 3)
}
