/*
 * This file is part of the repicea-statistics library.
 *
 * Copyright (C) 2009-2012 Mathieu Fortin for Rouge-Epicea
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed with the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * Please see the license at http://www.gnu.org/copyleft/lesser.html.
 */
package repicea.stats.data;


import repicea.math.Matrix;

/**
 * This interface is the basic interface for any data structure.
 * @author Mathieu Fortin - October 2011
 */
public interface StatisticalDataStructure {

	
	/**
	 * Returns the number of observations in the data structure.
	 * @return an integer
	 */
	public int getNumberOfObservations();
	

	/**
	 * This method builds the matrices that are required to fit the model. 
	 * @param modelDefinition the definition of the model that serves to design the matrices
	 * @throws StatisticalDataException
	 */
	public void constructMatrices(String modelDefinition) throws StatisticalDataException;
	
	/**
	 * Return the design matrix of the fixed effects.
	 * @return a Matrix instance
	 */
	public Matrix getMatrixX();

	/**
	 * Return the vector of response variables.
	 * @return a Matrix instance
	 */
	public Matrix getVectorY();
	
	/**
	 * This method returns true if the model has an intercept or false otherwise.
	 * @return a boolean instance
	 */
	public boolean isInterceptModel();
	
	/**
	 * This method determines whether the model has an intercept
	 * @param isInterceptModel true if the model has an intercept or false otherwise
	 */
	public void setInterceptModel(boolean isInterceptModel);
	
	
	
	/**
	 * This method returns the DataSet instance behind the StatisticalDataStructure.
	 * @return a DataSet instance
	 */
	public DataSet getDataSet();

}
