% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin-apply.R
\name{bin_apply}
\alias{bin_apply}
\alias{bin_apply_all}
\title{Bin a variable (typically time) and compute an aggregate for each bin}
\usage{
bin_apply(data, y, x = "t", x_bin_length = mins(30),
  wrap_x_by = NULL, FUN = mean, ...)

bin_apply_all(data, ...)
}
\arguments{
\item{data}{\link{data.table} or \link{behavr} table (see details)}

\item{y}{variable or expression to be aggregated}

\item{x}{variable or expression to be binned}

\item{x_bin_length}{length of the bins (same unit as \code{x})}

\item{wrap_x_by}{numeric value defining wrapping period. \code{NULL}, the default, means no wrapping (see details).}

\item{FUN}{function used to aggregate (e.g. \link{mean}, \link{median}, \link{sum} and so on)}

\item{...}{additional arguments to be passed to \code{FUN}}
}
\description{
This function is typically used to summarise (i.e. computing an aggregate of) a variable (\code{y})
for bins of a another variable \code{x} (typically time).
}
\details{
\code{bin_apply} expects data from a single individual, whilst
\code{bin_apply_all} works on multiple individuals identified by a unique key.
\code{wrapping} is typically used to compute averages across several periods.
For instance, \code{wrap_x_by = days(1)}, means bins will aggregate values across several days.
In this case, the resulting \code{x} can be interpreted as "time relative to the onset of the day" (i.e. Zeitgeber Time).
}
\examples{
metadata <- data.frame(id = paste0("toy_experiment|",1:5))
dt <- toy_activity_data(metadata, duration = days(2))

# average by 30min time bins, default
dt_binned <- bin_apply_all(dt, moving)
# equivalent to
dt_binned <- dt[, bin_apply(.SD, moving), by = "id"]

# if we want the opposite of moving:
dt_binned <- bin_apply_all(dt, !moving)

# More advanced usage
dt <- toy_dam_data(metadata, duration = days(2))

# sum activity per 60 minutes
dt_binned <- bin_apply_all(dt,
                           activity,
                           x = t,
                           x_bin_length = mins(60),
                           FUN = sum)


# average activity. Time in ZT
dt_binned <- bin_apply_all(dt,
                           activity,
                           x = t,
                           wrap_x_by = days(1)
                           )
}
\seealso{
\itemize{
\item \link{behavr} -- the documentation of the \code{behavr} object
}
}
