% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_mcmc.R
\name{create_test_mcmc}
\alias{create_test_mcmc}
\title{Create an MCMC configuration for testing.}
\usage{
create_test_mcmc(
  chain_length = 3000,
  store_every = 1000,
  pre_burnin = 0,
  n_init_attempts = 10,
  sample_from_prior = FALSE,
  tracelog = beautier::create_test_tracelog(),
  screenlog = beautier::create_test_screenlog(),
  treelog = beautier::create_test_treelog()
)
}
\arguments{
\item{chain_length}{length of the MCMC chain}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}

\item{pre_burnin}{number of burn in samples taken before entering
the main loop}

\item{n_init_attempts}{number of initialization attempts before failing}

\item{sample_from_prior}{set to \link{TRUE} to sample from the prior}

\item{tracelog}{a \code{tracelog},
as created by \link{create_tracelog}}

\item{screenlog}{a \code{screenlog},
as created by \link{create_screenlog}}

\item{treelog}{a \code{treelog},
as created by \link{create_treelog}}
}
\value{
an MCMC configuration
}
\description{
Create an MCMC configuration for testing.
}
\examples{
if (is_on_ci()) {

  # Create an MCMC chain with 50 states
  mcmc <- create_test_mcmc()

  beast2_input_file <- get_beautier_tempfilename()
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    mcmc = mcmc
  )
  file.remove(beast2_input_file)

  remove_beautier_folder()
}
}
\seealso{
Use \code{\link{create_mcmc}} to create a default BEAST2 MCMC
}
\author{
Richèl J.C. Bilderbeek
}
