% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContractionPipe.R
\name{ContractionPipe}
\alias{ContractionPipe}
\title{Class to find and/or replace the contractions on the data field of a Instance}
\description{
\code{\link{ContractionPipe}} class is responsible for detecting
the existing contractions in the \strong{data} field of each \code{\link{Instance}}.
Identified contractions are stored inside the \strong{contraction} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
contractions replacement.
}
\section{Details}{

\code{\link{ContractionPipe}} class requires the resource files (in json format)
containing the correspondence between contractions and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. contr.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.contractions.path"}
field of \emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{ContractionPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{ContractionPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ContractionPipe$new()}}
\item \href{#method-pipe}{\code{ContractionPipe$pipe()}}
\item \href{#method-findContraction}{\code{ContractionPipe$findContraction()}}
\item \href{#method-replaceContraction}{\code{ContractionPipe$replaceContraction()}}
\item \href{#method-getPropertyLanguageName}{\code{ContractionPipe$getPropertyLanguageName()}}
\item \href{#method-getResourcesContractionsPath}{\code{ContractionPipe$getResourcesContractionsPath()}}
\item \href{#method-setResourcesContractionsPath}{\code{ContractionPipe$setResourcesContractionsPath()}}
\item \href{#method-clone}{\code{ContractionPipe$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-getAlwaysBeforeDeps}{\code{bdpar::GenericPipe$getAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-getNotAfterDeps}{\code{bdpar::GenericPipe$getNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-getPropertyName}{\code{bdpar::GenericPipe$getPropertyName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash">}\href{../../bdpar/html/GenericPipe.html#method-hash}{\code{bdpar::GenericPipe$hash()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-setAlwaysBeforeDeps}{\code{bdpar::GenericPipe$setAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-setNotAfterDeps}{\code{bdpar::GenericPipe$setNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-setPropertyName}{\code{bdpar::GenericPipe$setPropertyName()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ContractionPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$new(
  propertyName = "contractions",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list(),
  replaceContractions = TRUE,
  resourcesContractionsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{replaceContractions}}{A \code{\link{logical}} value. Indicates if
the contractions are replaced or not.}

\item{\code{resourcesContractionsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the correspondence between
contractions and meaning.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/replace
the contractions. The contractions found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-findContraction"></a>}}
\if{latex}{\out{\hypertarget{method-findContraction}{}}}
\subsection{Method \code{findContraction()}}{
Checks if the contraction is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$findContraction(data, contraction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where contraction
will be searched.}

\item{\code{contraction}}{A \code{\link{character}} value. Indicates the
contraction to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
contraction is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-replaceContraction"></a>}}
\if{latex}{\out{\hypertarget{method-replaceContraction}{}}}
\subsection{Method \code{replaceContraction()}}{
Replaces the \emph{contraction} in the data for the
\emph{extendedContraction}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$replaceContraction(contraction, extendedContraction, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contraction}}{A \code{\link{character}} value. Indicates the
contraction to replace.}

\item{\code{extendedContraction}}{A \code{\link{character}} value. Indicates the
string to replace for the contractions found.}

\item{\code{data}}{A \code{\link{character}} value. The text where contraction
will be replaced.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the contractions replaced.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getResourcesContractionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-getResourcesContractionsPath}{}}}
\subsection{Method \code{getResourcesContractionsPath()}}{
Gets the path of contractions resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$getResourcesContractionsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of contractions resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setResourcesContractionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-setResourcesContractionsPath}{}}}
\subsection{Method \code{setResourcesContractionsPath()}}{
Sets the path of contractions resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$setResourcesContractionsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
contractions resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContractionPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
