% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_coordinates_country_inconsistent.R
\name{bdc_coordinates_country_inconsistent}
\alias{bdc_coordinates_country_inconsistent}
\title{Identify records within a reference country}
\usage{
bdc_coordinates_country_inconsistent(
  data,
  country_name,
  country = "country_suggested",
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  dist = 0.1
)
}
\arguments{
\item{data}{data.frame. Containing longitude and latitude. Coordinates must
be expressed in decimal degrees and WGS84.}

\item{country_name}{character string. Name of the country or countries to be
considered.}

\item{country}{character string. The column name with the country assignment
of each record. It is
recommended use a column with corrected and homogenized country names.
Default = "country_suggested".}

\item{lat}{character string. The column name with the latitude coordinates.
Default = “decimallatitude”.}

\item{lon}{character string. The column name with the longitude coordinates.
Default = “decimallongitude”.}

\item{dist}{numeric. The distance in decimal degrees used to created a buffer
around the country. Default = 0.1 (~11 km at the equator).}
}
\value{
A data.frame containing the column
'.coordinates_country_inconsistent'. Compliant (TRUE) if coordinates fall
within the boundaries plus a specified distance (if 'dist' is supplied) of
'country_name'; otherwise "FALSE".
}
\description{
This function flags geographic coordinates within a reference country. A
spatial buffer can be added to the reference country to ensure that
records in mangroves, marshes, estuaries, and records with low
coordinate precision are not flagged as invalid.
}
\details{
Multiple countries can be informed, but they are tested separately.
The distance reported in the argument 'dist' is used to create a
buffer around the reference country. Records within the reference country
or at a specified distance from the coastline of the reference country
(i.e., records within the buffer) are flagged as valid (TRUE). Note that
records within the buffer but in other countries are flagged as invalid
(FALSE). Records with invalid (e.g., NA or empty) and out-of-range
coordinates are not tested and returned as TRUE.
}
\examples{
\dontrun{
x <- data.frame(
  country = c("Brazil", "Brazil", "Bolivia", "Argentina", "Peru"),
  decimalLongitude = c(-40.6003, -39.6, -77.689288, NA, -76.352930),
  decimalLatitude = c(-19.9358, -13.016667, -20.5243, -35.345940, -11.851872)
)

bdc_coordinates_country_inconsistent(
  data = x,
  country_name = c("Brazil", "Peru", "Argentina"),
  country = "country",
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  dist = 0.1 
)
}
}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
