% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bct.v.R
\name{bct.v}
\alias{bct.v}
\title{Applying the Box-Cox Transformation to a numeric vector.}
\usage{
bct.v(y, lmdint = c(-3, 3))
}
\arguments{
\item{y}{a positive real number vector.}

\item{lmdint}{a vector containing the end-points of the interval to be
searched for a transformation parameter. Default is c(-3, 3).}
}
\value{
\code{bct.v} returns the Box-Cox transformed numeric vector and
estimated transformation parameter.
\describe{
  \item{\code{transformed}}{The Box-Cox transformed numeric vector.}
  \item{\code{lambda}}{a numeric value of the estimate of the transformation
        parameter.}
}
}
\description{
\code{bct.v} returns the Box-Cox transformed numeric vector (Box and Cox,
1964).
}
\examples{
  y <- exp(rnorm(50))
  bct.v(y)

}
\references{
Box, G.E.P. and Cox, D.R. (1964). An analysis of transformations
(with discussion).
\emph{Journals of the Royal Statistical Society, Series B}, 26,
211-246, \url{https://doi.org/10.1111/j.2517-6161.1964.tb00553.x}.
}
