% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics.HDP}
\alias{sufficientStatistics.HDP}
\title{Sufficient statistics of a "HDP" object}
\usage{
\method{sufficientStatistics}{HDP}(obj, x, ...)
}
\arguments{
\item{obj}{A "HDP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{...}{further arguments passed to the corresponding sufficientStatistics method of the "BasicBayesian" object.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure:
     \deqn{G_j|gamma ~ DP(gamma,U), j = 1:J}
     \deqn{pi_j|G_j,alpha ~ DP(alpha,G_j)}
     \deqn{z|pi_j ~ Categorical(pi_j)}
     \deqn{k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G}
     \deqn{theta_k|psi ~ H0(psi)}
     \deqn{x|theta_k,k ~ F(theta_k)}
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "HDP" object is simply a combination of a "CatHDP" object (see \code{?CatHDP}) and an object of any "BasicBayesian" type.\cr
In the case of HDP, z and k can only be positive integers. \cr
The sufficient statistics of a set of samples x in a "HDP" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP", see examples.
}
\examples{
## a HDP with Gaussian NIW observations
obj1 <- HDP(gamma=list(gamma=1,alpha=1,j=2,
                       H0aF="GaussianNIW",
                       parH0=list(m=0,k=1,v=2,S=1)))
## a HDP with Categorical-Dirichlet observations
obj2 <- HDP(gamma=list(gamma=1,alpha=1,j=2,
            H0aF="CatDirichlet",
            parH0=list(alpha=1,uniqueLabels=letters[1:3])))
x1 <- rnorm(100)
x2 <- sample(letters[1:3],100,replace = TRUE)
sufficientStatistics(obj = obj1,x=x1,foreach = TRUE)
sufficientStatistics(obj = obj1,x=x1,foreach = FALSE)
sufficientStatistics(obj = obj2,x=x2,foreach = FALSE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{HDP}}, \code{\link{sufficientStatistics_Weighted.HDP}}
}
