% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveBatch.R
\name{ArchiveBatch}
\alias{ArchiveBatch}
\title{Data Table Storage}
\description{
The \code{ArchiveBatch} stores all evaluated points and performance scores in a \code{\link[data.table:data.table]{data.table::data.table()}}.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(archive)}\cr
\link{ArchiveBatch} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a tabular view of all performed function calls of the Objective.
The \code{x_domain} column is unnested to separate columns.
}
}

\section{Super class}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{ArchiveBatch}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Contains all performed \link{Objective} function calls.}

\item{\code{data_extra}}{(named \code{list})\cr
Data created by specific \code{\link{Optimizer}}s that does not relate to any individual function evaluation and can therefore not be held in \verb{$data}.
Every optimizer should create and refer to its own entry in this list, named by its \code{class()}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n_evals}}{(\code{integer(1)})\cr
Number of evaluations stored in the archive.}

\item{\code{n_batch}}{(\code{integer(1)})\cr
Number of batches stored in the archive.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveBatch-new}{\code{ArchiveBatch$new()}}
\item \href{#method-ArchiveBatch-add_evals}{\code{ArchiveBatch$add_evals()}}
\item \href{#method-ArchiveBatch-best}{\code{ArchiveBatch$best()}}
\item \href{#method-ArchiveBatch-nds_selection}{\code{ArchiveBatch$nds_selection()}}
\item \href{#method-ArchiveBatch-clear}{\code{ArchiveBatch$clear()}}
\item \href{#method-ArchiveBatch-clone}{\code{ArchiveBatch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="help"><a href='../../bbotk/html/Archive.html#method-Archive-help'><code>bbotk::Archive$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="print"><a href='../../bbotk/html/Archive.html#method-Archive-print'><code>bbotk::Archive$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$new(search_space, codomain, check_values = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should x-values that are added to the archive be checked for validity?
Search space that is logged into archive.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-add_evals"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-add_evals}{}}}
\subsection{Method \code{add_evals()}}{
Adds function evaluations to the archive table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$add_evals(xdt, xss_trafoed = NULL, ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}

\item{\code{xss_trafoed}}{(\code{list()})\cr
Transformed point(s) in the \emph{domain space}.}

\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Optimal outcome.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-best"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-best}{}}}
\subsection{Method \code{best()}}{
Returns the best scoring evaluation(s).
For single-crit optimization, the solution that minimizes / maximizes the objective function.
For multi-crit optimization, the Pareto set / front.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$best(batch = NULL, n_select = 1L, ties_method = "first")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{batch}}{(\code{integer()})\cr
The batch number(s) to limit the best results to.
Default is all batches.}

\item{\code{n_select}}{(\code{integer(1L)})\cr
Amount of points to select.
Ignored for multi-crit optimization.}

\item{\code{ties_method}}{(\code{character(1L)})\cr
Method to break ties when multiple points have the same score.
Either \code{"first"} (default) or \code{"random"}.
Ignored for multi-crit optimization.
If \code{n_select > 1L}, the tie method is ignored and the first point is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-nds_selection"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-nds_selection}{}}}
\subsection{Method \code{nds_selection()}}{
Calculate best points w.r.t. non dominated sorting with hypervolume contribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$nds_selection(batch = NULL, n_select = 1, ref_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{batch}}{(\code{integer()})\cr
The batch number(s) to limit the best points to. Default is
all batches.}

\item{\code{n_select}}{(\code{integer(1L)})\cr
Amount of points to select.}

\item{\code{ref_point}}{(\code{numeric()})\cr
Reference point for hypervolume.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-clear"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all evaluation results from archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBatch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBatch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBatch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
