% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackOptimization.R
\name{callback_optimization}
\alias{callback_optimization}
\title{Create Optimization Callback}
\usage{
callback_optimization(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_optimizer_after_eval = NULL,
  on_result = NULL,
  on_optimization_end = NULL,
  fields = list()
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_result}{(\verb{function()})\cr
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{fields}{(list of \code{any})\cr
List of additional fields.}
}
\description{
Function to create a \link{CallbackOptimization}.

Optimization callbacks can be called from different stages of optimization process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Optimization
     - on_optimization_begin
    Start Optimizer Batch
         - on_optimizer_before_eval
         - on_optimizer_after_eval
    End Optimizer Batch
     - on_result
     - on_optimization_end
End Optimization
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A optimization callback works with \link{ContextOptimization}.
}
\details{
A callback can write data to its state (\verb{$state}), e.g. settings that affect the callback itself.
The \link{ContextOptimization} allows to modify the instance, archive, optimizer and final result.
}
\examples{
# write archive to disk
callback_optimization("bbotk.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
