% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{bbotk_assertions}
\alias{bbotk_assertions}
\alias{assert_terminator}
\alias{assert_terminable}
\alias{assert_set}
\alias{assert_optimizer}
\alias{assert_instance_properties}
\alias{assert_codomain}
\title{Assertion for bbotk objects}
\usage{
assert_terminator(terminator, instance = NULL)

assert_terminable(terminator, instance)

assert_set(x, empty = TRUE, .var.name = vname(x))

assert_optimizer(optimizer)

assert_instance_properties(optimizer, inst)

assert_codomain(codomain)
}
\arguments{
\item{terminator}{(\link{Terminator}).}

\item{instance}{(\link{OptimInstance}).}

\item{x}{(any)}

\item{empty}{(\code{logical(1)})}

\item{.var.name}{(\code{character(1)})}

\item{optimizer}{(\link{Optimizer}).}

\item{codomain}{(\link[paradox:ParamSet]{paradox::ParamSet}).}
}
\description{
Most assertion functions ensure the right class attribute, and optionally
additional properties. Additionally, the following compound assertions are
implemented:
\itemize{
\item \code{assert_terminable(terminator, instance)}\cr
(\link{Terminator}, \link{OptimInstance}) -> \code{NULL}\cr
Checks if the terminator is applicable to the optimization.
\item \code{assert_instance_properties(optimizer, instance)}\cr
(\link{Optimizer}, \link{OptimInstance}) -> \code{NULL}\cr
Checks if the instance is applicable to the optimizer.
}

If an assertion fails, an exception is raised. Otherwise, the input object is
returned invisibly.
}
\keyword{internal}
