% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{bb_series}
\alias{bb_series}
\title{Returns the time serie that is found with the specified time series key}
\usage{
bb_series(key)
}
\arguments{
\item{key}{\code{character(1)} key to query.}
}
\value{
A \code{data.frame()} with the requested data. The columns are:
\item{date}{The date of the observation}
\item{value}{The value of the observation}
\item{key}{The time series key}
\item{title}{The title of the dataflow}
\item{frequency}{The frequency of the observation}
\item{category}{The category of the observation}
\item{unit}{The unit of the observation}
\item{unit_multiplier}{The unit multiplier of the observation}
\item{last_update}{The last update date}
\item{source}{The source of the data}
\item{comment}{A comment on the data}
}
\description{
Returns the time serie that is found with the specified time series key
}
\examples{
\donttest{
bb_series("BBEX3.M.DKK.EUR.BB.AC.A01")
bb_series("BBAF3.Q.F41.S121.DE.S1.W0.LE.N._X.B")
bb_series("BBBK11.D.TTA000")
}
}
\references{
\url{https://www.bundesbank.de/en/statistics/time-series-databases/help-for-sdmx-web-service/web-service-interface-data}
}
\seealso{
Other data: 
\code{\link{bb_data}()}
}
\concept{data}
