% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qw.import.R
\name{qw.import}
\alias{qw.import}
\title{qw.import}
\usage{
qw.import(fn.import, qw.names, rounding = c(3, 4))
}
\arguments{
\item{fn.import}{Filename (with path) containing data.  Comma separated (CSV) format only.}

\item{qw.names}{Names of parameters for QW columns.}

\item{rounding}{OPTIONAL.  Rounding values for QW columns.  Default is c(3,4) but can be changed.}
}
\value{
Returns a QW enabled data frame.
}
\description{
Import the contents of tab delimited text files to a QW object.
}
\details{
This internal function will import data from a comma delimited (CSV) file 
to create a data frame with columns of the qw class.  

Only three slots are recognized by this function; ".Data" and "remark.codes" 
The slot name ".Data" includes ".Data.values" and ".Data.value2".

These three slots are marked as "_lo", "_hi", and "_symbol" in the import file 
the prefix of the parameter name to be used in the qw object; e.g., secchi_lo,
secchi_hi, and secchi_symbol.
 
To view all qw slot names use the command slotNames("qw").  
 
The function returns a data frame with QW enabled columns.  The user must save the file.  
Any modification of column classes needs to be handled by the user (e.g., character to date or POSIXct).
}
\examples{
# Use internal function to export dataCensored as example for import
qw.export(dataCensored, getwd(), "dataCensored_TEST.csv")


# Import Test file as a qw object

# Define function parameters
fn.import <- file.path(".", "dataCensored_TEST.csv")
qw.names <- c("secchi", "chla", "do", "tn", "tp", "po4", "tdp"
              , "no23", "nh4", "tdn", "tss")
rounding <- c(3, 4)

# Import
dataCensored.test<- qw.import(fn.import, qw.names, rounding)

# Check for qw class
str(dataCensored.test)

# Save
save(dataCensored.test, file="dataCensored.test.rda")


# Show slot names for a qw object.
slotNames("qw")

####
# convert date field to POSIXct
#dataCensored.test[,"date"] <- as.POSIXct(dataCensored.test[,"date"])
# str(dataCensored.test)
# as.numeric() and as.integer() can be used to convert columns of those types.
}
