% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrBase_baseDay.R
\name{baseDay}
\alias{baseDay}
\title{Base Day}
\usage{
baseDay(x, numeric = TRUE, year = c("calendar", "water", "climate"))
}
\arguments{
\item{x}{a vector of class POSIXt, Dates, or character that represents a
date. Missing values are permitted.}

\item{numeric}{a logical value; \code{TRUE} means return the numeric value
of the day, \code{FALSE} means return a factor.}

\item{year}{a character string indicating the basis of the factor levels. See
\bold{Details}.}
}
\value{
An integer value representing the base day number if \code{numeric}
is \code{TRUE}. Otherwise a factor with levels for every day of the year.
}
\description{
Computes the base day of the year, a reference value that can be 
used to group days for the computation of summary statistics.  From smwrBase package.
}
\details{
The base day is computed such that all dates have the same reference value
regardless of whether the year is a leap year or not. If \code{year} is 
"calendar," then the factor levels or day number begin on January 1; if \code{year} is
"water," then the factor levels or day number begin on October 1; and if \code{year} is
"climate," then the factor levels or day number begin on April 1.
}
\examples{

# The default numeric result
baseDay(c("2000-02-29", "2000-03-01", "2001-03-01"))
# The result as a factor
baseDay(c("2000-02-29", "2000-03-01", "2001-03-01"), numeric=FALSE)
}
\keyword{internal}
\keyword{manip}
