% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bci.R
\name{bci}
\alias{bci}
\alias{bcai}
\alias{bci.numeric}
\alias{bci.data.frame}
\alias{bci.MCMCglmm}
\alias{bci.sim.merMod}
\alias{bci.sim}
\alias{bci.emmGrid}
\alias{bci.stanreg}
\alias{bci.brmsfit}
\alias{bci.BFBayesFactor}
\title{Bias Corrected and Accelerated Interval (BCa)}
\usage{
bci(x, ...)

bcai(x, ...)

\method{bci}{numeric}(x, ci = 0.95, verbose = TRUE, ...)

\method{bci}{data.frame}(x, ci = 0.95, verbose = TRUE, ...)

\method{bci}{MCMCglmm}(x, ci = 0.95, verbose = TRUE, ...)

\method{bci}{sim.merMod}(
  x,
  ci = 0.95,
  effects = c("fixed", "random", "all"),
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{bci}{sim}(x, ci = 0.95, parameters = NULL, verbose = TRUE, ...)

\method{bci}{emmGrid}(x, ci = 0.95, verbose = TRUE, ...)

\method{bci}{stanreg}(
  x,
  ci = 0.95,
  effects = c("fixed", "random", "all"),
  component = c("location", "all", "conditional", "smooth_terms", "sigma",
    "distributional", "auxiliary"),
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{bci}{brmsfit}(
  x,
  ci = 0.95,
  effects = c("fixed", "random", "all"),
  component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{bci}{BFBayesFactor}(x, ci = 0.95, verbose = TRUE, ...)
}
\arguments{
\item{x}{Vector representing a posterior distribution, or a data frame of such
vectors. Can also be a Bayesian model. \strong{bayestestR} supports a wide range
of models (see, for example, \code{methods("hdi")}) and not all of those are
documented in the 'Usage' section, because methods for other classes mostly
resemble the arguments of the \code{.numeric} or \code{.data.frame}methods.}

\item{...}{Currently not used.}

\item{ci}{Value or vector of probability of the (credible) interval - CI
(between 0 and 1) to be estimated. Default to \code{.95} (\verb{95\%}).}

\item{verbose}{Toggle off warnings.}

\item{effects}{Should results for fixed effects, random effects or both be
returned? Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters
that should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the
conditional model or the zero-inflated part of the model be returned? May
be abbreviated. Only applies to \pkg{brms}-models.}
}
\value{
A data frame with following columns:
\itemize{
\item \code{Parameter} The model parameter(s), if \code{x} is a model-object. If \code{x} is a vector, this column is missing.
\item \code{CI} The probability of the credible interval.
\item \code{CI_low}, \code{CI_high} The lower and upper credible interval limits for the parameters.
}
}
\description{
Compute the \strong{Bias Corrected and Accelerated Interval (BCa)} of posterior
distributions.
}
\details{
Unlike equal-tailed intervals (see \code{eti()}) that typically exclude \verb{2.5\%}
from each tail of the distribution and always include the median, the HDI is
\emph{not} equal-tailed and therefore always includes the mode(s) of posterior
distributions. While this can be useful to better represent the credibility
mass of a distribution, the HDI also has some limitations. See \code{\link[=spi]{spi()}} for
details.
\cr \cr
The \href{https://easystats.github.io/bayestestR/articles/credible_interval.html}{\verb{95\%} or \verb{89\%} Credible Intervals (CI)}
are two reasonable ranges to characterize the uncertainty related to the estimation (see \href{https://easystats.github.io/bayestestR/articles/credible_interval.html}{here} for a discussion about the differences between these two values).
\cr
The \verb{89\%} intervals (\code{ci = 0.89}) are deemed to be more stable than, for
instance, \verb{95\%} intervals (\cite{Kruschke, 2014}). An effective sample size
of at least 10.000 is recommended if one wants to estimate \verb{95\%} intervals
with high precision (\cite{Kruschke, 2014, p. 183ff}). Unfortunately, the
default number of posterior samples for most Bayes packages (e.g., \code{rstanarm}
or \code{brms}) is only 4.000 (thus, you might want to increase it when fitting
your model). Moreover, 89 indicates the arbitrariness of interval limits -
its only remarkable property is being the highest prime number that does not
exceed the already unstable \verb{95\%} threshold (\cite{McElreath, 2015}).
\cr
However, \verb{95\%} has some \href{https://easystats.github.io/blog/posts/bayestestr_95/}{advantages too}. For instance, it
shares (in the case of a normal posterior distribution) an intuitive
relationship with the standard deviation and it conveys a more accurate image
of the (artificial) bounds of the distribution. Also, because it is wider, it
makes analyses more conservative (i.e., the probability of covering 0 is
larger for the \verb{95\%} CI than for lower ranges such as \verb{89\%}), which is a good
thing in the context of the reproducibility crisis.
\cr \cr
A \verb{95\%} equal-tailed interval (ETI) has \verb{2.5\%} of the distribution on either
side of its limits. It indicates the 2.5th percentile and the 97.5h
percentile. In symmetric distributions, the two methods of computing credible
intervals, the ETI and the \link[=hdi]{HDI}, return similar results.
\cr \cr
This is not the case for skewed distributions. Indeed, it is possible that
parameter values in the ETI have lower credibility (are less probable) than
parameter values outside the ETI. This property seems undesirable as a summary
of the credible values in a distribution.
\cr \cr
On the other hand, the ETI range does change when transformations are applied
to the distribution (for instance, for a log odds scale to probabilities):
the lower and higher bounds of the transformed distribution will correspond
to the transformed lower and higher bounds of the original distribution.
On the contrary, applying transformations to the distribution will change
the resulting HDI.
}
\examples{
posterior <- rnorm(1000)
bci(posterior)
bci(posterior, ci = c(.80, .89, .95))
}
\references{
DiCiccio, T. J. and B. Efron. (1996). Bootstrap Confidence Intervals.
Statistical Science. 11(3): 189–212. 10.1214/ss/1032280214
}
\seealso{
Other ci: 
\code{\link{ci}()},
\code{\link{cwi}()},
\code{\link{eti}()},
\code{\link{hdi}()},
\code{\link{si}()},
\code{\link{spi}()}
}
\concept{ci}
