% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dfa.R
\name{fit_dfa}
\alias{fit_dfa}
\title{Fit a Bayesian DFA}
\usage{
fit_dfa(y = y, num_trends = 1, varIndx = NULL, zscore = TRUE,
  iter = 2000, chains = 4, thin = 1, control = list(adapt_delta =
  0.99, max_treedepth = 20), nu_fixed = 101, est_correlation = FALSE,
  estimate_nu = FALSE, estimate_trend_ar = FALSE,
  estimate_trend_ma = FALSE, sample = TRUE, data_shape = c("wide",
  "long"), obs_covar = NULL, pro_covar = NULL, ...)
}
\arguments{
\item{y}{A matrix of data to fit. See \code{data_shape} option to specify whether
this is long or wide format data.}

\item{num_trends}{Number of trends to fit.}

\item{varIndx}{Indices indicating which timeseries should have shared
variances.}

\item{zscore}{Logical. Should the data be standardized first? If not it is
just centered. Centering is necessary because no intercept is included.}

\item{iter}{Number of iterations in Stan sampling, defaults to 2000.}

\item{chains}{Number of chains in Stan sampling, defaults to 4.}

\item{thin}{Thinning rate in Stan sampling, defaults to 1.}

\item{control}{A list of options to pass to Stan sampling. Defaults to
\code{list(adapt_delta = 0.99, max_treedepth = 20)}.}

\item{nu_fixed}{Student t degrees of freedom parameter. If specified as
greater than 100, a normal random walk is used instead of a random walk
with a t-distribution. Defaults to \code{101}.}

\item{est_correlation}{Boolean, whether to estimate correlation of
observation error matrix \code{R}. Defaults to \code{FALSE}.}

\item{estimate_nu}{Logical. Estimate the student t degrees of freedom
parameter? Defaults to \code{FALSE},}

\item{estimate_trend_ar}{Logical. Estimate AR(1) parameters on DFA trends?
Defaults to `FALSE``, in which case AR(1) parameters are set to 1}

\item{estimate_trend_ma}{Logical. Estimate MA(1) parameters on DFA trends?
Defaults to `FALSE``, in which case MA(1) parameters are set to 0.}

\item{sample}{Logical. Should the model be sampled from? If \code{FALSE}, then the
data list object that would have been passed to Stan is returned instead.
This is useful for debugging and simulation. Defaults to \code{TRUE}.}

\item{data_shape}{If \code{wide} (the current default) then the input data should
have rows representing the various timeseries and columns representing the
values through time. This matches the MARSS input data format. If \code{long}
then the input data should have columns representing the various timeseries
and rows representing the values through time.}

\item{obs_covar}{Optional dataframe of data with 4 named columns ("time","timeseries","covariate","value"), representing: (1) time, (2) the time series
affected, (3) the covariate number for models with more than one covariate affecting each
trend, and (4) the value of the covariate}

\item{pro_covar}{Optional dataframe of data with 4 named columns ("time","trend","covariate","value"), representing: (1) time, (2) the trend
affected, (3) the covariate number for models with more than one covariate affecting each
trend, and (4) the value of the covariate}

\item{...}{Any other arguments to pass to \code{\link[rstan:sampling]{rstan::sampling()}}.}
}
\description{
Fit a Bayesian DFA
}
\details{
Note that there is nothing restricting the loadings and trends from
being inverted (i.e. multiplied by \code{-1}) for a given chain. Therefore, if
you fit multiple chains, the package will attempt to determine which chains
need to be inverted using the function \code{\link[=find_inverted_chains]{find_inverted_chains()}}.
}
\examples{
set.seed(42)
s <- sim_dfa(num_trends = 1, num_years = 20, num_ts = 3)
# only 1 chain and 250 iterations used so example runs quickly:
m <- fit_dfa(y = s$y_sim, iter = 250, chains = 1)
\dontrun{
# example of observation error covariates
obs_covar = expand.grid("time"=1:20,"timeseries"=1:3,"covariate"=1)
obs_covar$value=rnorm(nrow(obs_covar),0,0.1)
m <- fit_dfa(y = s$y_sim, iter = 250, chains = 1, obs_covar=obs_covar)

# example of process error covariates
pro_covar = expand.grid("time"=1:20,"trend"=1:3,"covariate"=1)
pro_covar$value=rnorm(nrow(pro_covar),0,0.1)
m <- fit_dfa(y = s$y_sim, iter = 250, chains = 1, pro_covar=pro_covar)
}
}
\seealso{
plot_loadings plot_trends rotate_trends find_swans
}
