% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survivalBACT}
\alias{survivalBACT}
\title{Time-to-event outcome for Bayesian Adaptive Trials}
\usage{
survivalBACT(hazard_treatment, cutpoint = NULL, hazard_control = NULL,
  N_total, breaks = NULL, time0 = NULL, treatment0 = NULL,
  event0 = NULL, lambda = 0.3, lambda_time = NULL,
  interim_look = NULL, EndofStudy, prior = c(0.1, 0.1), block = 2,
  rand_ratio = c(1, 1), prop_loss_to_followup = 0.1,
  alternative = "greater", h0 = 0, futility_prob = 0.05,
  expected_success_prob = 0.9, prob_ha = 0.95, N_impute = 10,
  number_mcmc = 10000, discount_function = "identity", alpha_max = 1,
  fix_alpha = FALSE, weibull_scale = 0.135, weibull_shape = 3,
  method = "fixed")
}
\arguments{
\item{hazard_treatment}{vector. Constant hazard rates under the treatment arm.}

\item{cutpoint}{vector. The change-point vector indicating time when the hazard rates change.}

\item{hazard_control}{vector. Constant hazard rates under the control arm.}

\item{N_total}{scalar. Total sample size.}

\item{breaks}{vector. Breaks (interval starts) used to compose the breaks of the piecewise
exponential model. Do not include zero. Default breaks are the quantiles of the input
times.}

\item{time0}{vector. Historical exposure time for the subjects. It must be the same length
as the treatment variable.}

\item{treatment0}{vector. the historical treatment assignment for patients,
1 for treatment group and 0 for control group.}

\item{event0}{vector. Historical status indicator, normally 0=alive, 1=dead.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death).
For censored data, the status indicator is 0=right censored, 1 = event at time.
Although unusual, the event indicator can be omitted, in which case
all subjects are assumed to have an event.}

\item{lambda}{vector. Enrollment rates across simulated enrollment times. See
\code{\link{enrollment}} for more details.}

\item{lambda_time}{vector. Enrollment time(s) at which the enrollment rates
change. Must be same length as lambda. See \code{\link{enrollment}} for
more details.}

\item{interim_look}{vector. Sample size for each interim look. Note: the
maximum sample size should not be included.}

\item{EndofStudy}{scalar. Length of the study.}

\item{prior}{vector. Prior values of the gamma rate, Gamma(a0, b0). The default is
set to Gamma(.1, .1).}

\item{block}{scalar. Block size for generating the randomization schedule.}

\item{rand_ratio}{vector. Randomization allocation for the ratio of control
to treatment. Integer values mapping the size of the block. See
\code{\link{randomization}} for more details.}

\item{prop_loss_to_followup}{scalar. Overall oroportion of subjects lost to
follow-up.}

\item{alternative}{character. The string specifying the alternative
hypothesis, must be one of \code{"greater"} (default), \code{"less"} or
\code{"two.sided"}.}

\item{h0}{scalar. Threshold for comparing two mean values. Default is
\code{h0=0}.}

\item{futility_prob}{scalar. Probability of stopping early for futility.}

\item{expected_success_prob}{scalar. Probability of stopping early for success.}

\item{prob_ha}{scalar. Probability of alternative hypothesis.}

\item{N_impute}{scalar. Number of imputations for Monte Carlo simulation of
missing data.}

\item{number_mcmc}{scalar. Number of Monte Carlo Markov Chain draws in
sampling posterior.}

\item{discount_function}{character. If incorporating historical data, specify
the discount function. Currently supports the Weibull function
(\code{discount_function="weibull"}), the scaled-Weibull function
(\code{discount_function="scaledweibull"}), and the identity function
(\code{discount_function="identity"}). The scaled-Weibull discount function
scales the output of the Weibull CDF to have a max value of 1. The identity
discount function uses the posterior probability directly as the discount
weight. Default value is \code{"identity"}. See \code{\link{bdpnormal}} for
more details.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when discount_function =
"identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when discount_function = "identity".}

\item{method}{character. Analysis method with respect to estimation of the weight
paramter alpha. Default method "\code{mc}" estimates alpha for each
Monte Carlo iteration. Alternate value "\code{fixed}" estimates alpha once
and holds it fixed throughout the analysis.  See the the
\code{bdpsurvival} vignette \cr
\code{vignette("bdpsurvival-vignette", package="bayesDP")} for more details.}
}
\value{
a list of output for a single trial simulation.
\describe{
  \item{\code{lambda_treatment}}{
    vector. The input parameter of constant hazard rates in the
    treatment group.}
  \item{\code{cutpoint_treatment}}{
    vector. The change-point vector when the constant hazard rate(s) changes for
    the treatment group.}
  \item{\code{lambda_control}}{
    vector. The input parameter of constant hazard rates in the
    control group.}
  \item{\code{cutpoint_control}}{
    vector. The change-point vector when the constant hazard rate(s) changes for
    the control group.}
  \item{\code{prob_of_accepting_alternative}}{
    scalar. The input parameter of probability threshold of accepting the
    alternative.}
  \item{\code{margin}}{
    scalar. The margin input value of difference between mean estimate of treatment
     and mean estimate of the control.}
  \item{\code{alternative}}{
    character. The input parameter of alternative hypothesis. }
  \item{\code{interim_look}}{
    vector. The sample size for each interim look.}
  \item{\code{N_treatment}}{
    scalar. The number of patients enrolled in the treatment group for
    each simulation.}
  \item{\code{event_treatment}}{
    scalar. The number of events in the treatment group for
    each simulation.}
  \item{\code{N_control}}{
    scalar. The number of patients enrolled in the control group for
    each simulation.}
  \item{\code{event_control}}{
    scalar. The number of events in the control group for
    each simulation.}
  \item{\code{N_enrolled}}{
    vector. The number of patients enrolled in the trial (sum of control
    and experimental group for each simulation. )}
  \item{\code{N_complete}}{
    scalar. The number of patients who completed the trial and had no
    loss to follow-up.}
  \item{\code{post_prob_accept_alternative}}{
    vector. The final probability of accepting the alternative
    hypothesis after the analysis is done.}
  \item{\code{est_final}}{
    scalar. The final estimate of the difference in posterior estimate of
    treatment and posterior estimate of the control group.}
  \item{\code{stop_futility}}{
    scalar. Did the trial stop for futility during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}
  \item{\code{stop_expected_success}}{
    scalar. Did the trial stop for early success during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}
  \item{\code{est_interim}}{
    scalar. The interim estimate of the difference in posterior estimate of
    treatment and posterior estimate of the control group.}
}
}
\description{
Simulation for time-to-event outcome for Bayesian Adaptive trial with
  different inputs to control for power, sample size, type 1 error rate, etc.
}
\examples{
survivalBACT(0.01, NULL, 0.014, 200, EndofStudy = 100)


}
