% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sequence.R
\name{clean_sequence}
\alias{clean_sequence}
\title{Clean DNA or RNA sequence}
\usage{
clean_sequence(sequence, type = "DNA")
}
\arguments{
\item{sequence}{A character string containing the DNA or RNA sequence to be cleaned.}

\item{type}{A character string indicating the type of sequence. The default is "DNA". If set to "RNA", the function will remove any characters that are not A, C, G, U.}
}
\value{
A character string containing the cleaned DNA or RNA sequence.
}
\description{
This function takes a DNA or RNA sequence as input and removes any characters that are not A, C, G, T (for DNA) or A, C, G, U (for RNA).
}
\examples{
clean_sequence("atgcNnRYMK") # Returns "ATGC"
clean_sequence("auggcuuNnRYMK", type = "RNA") # Returns "AUGGCUU"
}
