% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sequence.R
\name{clean_sequence}
\alias{clean_sequence}
\title{Clean DNA/RNA sequence}
\usage{
clean_sequence(sequence, type = "DNA")
}
\arguments{
\item{sequence}{a DNA/RNA sequence string}

\item{type}{a character string indicating the type of sequence ("DNA" or "RNA")}
}
\value{
a cleaned DNA/RNA sequence string
}
\description{
This function cleans DNA/RNA sequences by removing any characters that are not A, C, G, T/U.
}
\examples{
sequence <- "ATGACTGCNATGCNCTAG"
clean_sequence(sequence, type = "DNA")
# [1] "ATGACTGCATGCCTAG"

sequence <- "AUGACUGCNAUGCNCUAG"
clean_sequence(sequence, type = "RNA")
# [1] "AUGACUGCAUGCCUAG"
}
