% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_schedule_info.R
\name{ncaa_schedule_info}
\alias{ncaa_schedule_info}
\title{\strong{Get Schedule and Results for NCAA Baseball Teams}}
\usage{
ncaa_schedule_info(teamid = NULL, year = NULL)
}
\arguments{
\item{teamid}{The team's unique NCAA id.}

\item{year}{The season (i.e. use 2016 for the 2015-2016 season,
etc.)}
}
\value{
A data frame with the following fields: date, opponent,
result, score, innings (if more than regulation), and the url
for the game itself.\tabular{ll}{
   col_name \tab types \cr
   date \tab character \cr
   opponent \tab character \cr
   result \tab character \cr
   score \tab character \cr
   innings \tab character \cr
   opponent_slug \tab character \cr
   slug \tab character \cr
   game_info_url \tab character \cr
}
}
\description{
\strong{Get Schedule and Results for NCAA Baseball Teams}
}
\examples{
\donttest{
  try(ncaa_schedule_info(teamid = 736, year = 2021))
}
}
