% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-chapy.R
\encoding{UTF-8}
\name{model.chapy.customize}
\alias{model.chapy.customize}
\title{Customize CHAPY}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{dd_onset_threshold}{Degree days that are required to trigger the onset of
infestation. Additionally, the maximum temperature must exceed \code{tfly}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_development_base}{Base temperature to calculate degree days for development.}

\item{dd_total_dev}{Degree days that are required for a generation to fully
develop}

\item{dev_start, dev_end}{Share in total development when the egg development starts and the
juvenile beetle's development ends respectively. Usable if the development
below/above these thresholds should account for mating, oviposition etc.}

\item{dev_sister_brood}{Share in the total development, when a sister brood
will be established.}

\item{dev_mortal_min, dev_mortal_max}{The beetles are considered to be in
white stages (egg, larva, pupa) if their development exceeds \code{dev_mortal_min}
and subceeds \code{dev_mortal_max}. During these stages, the beetles could die
caused by a mortality event. \code{NULL} means that no lower/upper threshold is
defined.}

\item{func_ftmin, func_ftmean, func_ftmax}{Functions to caclulate the
air temperature in forest stands (see \insertCite{Ogris2019;nobrackets}{barrks},
equations 1 - 3). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{tmin}: min air temperature
\item \code{tmean}: mean air temperature
\item \code{tmax}: maximum air temperature
}}

\item{func_btmin, func_btmean, func_btmax}{Functions to caclulate the
bark temperature (see \insertCite{Ogris2019;nobrackets}{barrks},
equations 4 - 6). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{ftmin}: min air temperature in forest stands
\item \code{ftmean}: mean air temperature in forest stands
\item \code{ftmax}: maximum air temperature in forest stands
}}

\item{dt_low, dt_up, topt, tmax, alpha, beta, gamma}{Parameters to calculate
the effective bark temperature (see \insertCite{Ogris2020;nobrackets}{barrks},
equations A.7 - A.9).}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{daylength_dia}{When the daylength falls below this threshold, diapause
will be initiated.}

\item{mortality_date}{Date when all white stages (egg, larva, pupa) die.}
}
\description{
This page describes the parameters
that can be used to customize CHAPY. The model was developed by
\insertCite{Ogris2020;textual}{barrks}. Look \link[=model.chapy.customize]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for CHAPY and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
model("chapy",

      # ==== onset ====

      dd_onset_start_date = '03-09',
      dd_onset_base = 7.4,
      dd_onset_threshold = 216.5,

      # ==== onset + development ====

      tfly = 15.6,

      # ==== development ====

      dd_development_base = 7.4,
      dd_total_dev = 635.4,
      dev_start = 0,
      dev_end = 1,
      dev_sister_brood = 0.5,
      dev_mortal_min = NULL,
      dev_mortal_max = 0.8,

      func_ftmin = function(tmin) \{ 1.44 + 0.82 * tmin \},
      func_ftmean = function(tmean) \{ 0.50 + 0.81 * tmean \},
      func_ftmax = function(tmax) \{ 1.03 + 0.86 * tmax \},

      func_btmin = function(atmin) \{ 0.56 + 0.99 * atmin \},
      func_btmean = function(atmean) \{ -0.48 + 1.03 * atmean \},
      func_btmax = function(atmax) \{ 0.03 + 0.99 * atmax \},

      dt_low = 7.4,
      dt_up = 39.4,
      topt = 30,
      tmax = 41.97,
      alpha = 0.031,
      beta = 5.3,
      gamma = 1.25,

      model_end_date = '12-31',

      # ==== diapause ====

      daylength_dia = 13.6,

      # ==== mortality ====

      mortality_date = '12-31'
)

}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.chapy.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.phenips_clim.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
