% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.simmelian}
\alias{sparsify.with.simmelian}
\title{Extract Nick et al's (2013) Simmelian backbone}
\usage{
sparsify.with.simmelian(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a two-column dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.}

\item{s}{numeric: Sparsificiation threshold, 0 < s < 1; larger values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.simmelian} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the simmelian backbone described by Nick et al. (2013).
It is equivalent to \code{sparsify(escore = "triangles", normalize = "embeddedness", filter = "threshold", umst = FALSE)}.
}
\examples{
U <- igraph::sbm.game(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.simmelian(U, s = 0.5, narrative = TRUE)
plot(sparse) #Clearly visible communities
}
\references{
{Nick, B., Lee, C., Cunningham, P., & Brandes, U. (2013, August). Simmelian backbones: Amplifying hidden homophily in facebook networks. In Proceedings of the 2013 IEEE/ACM international conference on advances in social networks analysis and mining (pp. 525-532). \doi{10.1145/2492517.2492569}}
}
